// robit.c
// 12/11/2013

#define F_CPU 16000000UL
#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>

uint8_t adc_read(uint8_t channel)
{
    // select adc channel
    ADMUX = 0x60 | channel;
    //ADMUX |= channel;

    // start conversion
    ADCSRA |= _BV(ADSC);

    // wait for completion
    while (!(ADCSRA & _BV(ADIF)));

    // acknowledge
    ADCSRA |= _BV(ADIF);

    return ADCH;
}

void adc_enable()
{
    // prescaler 128, clock 16Mhz -> 125KHz
    ADCSRA |= _BV(ADPS2) | (0 << ADPS1) | _BV(ADPS0);
    // Aref = Vcc
    ADMUX = _BV(ADLAR);
    // enable ADC
    ADCSRA |= _BV(ADEN);
}

extern unsigned char sample_idx;//= 0;
extern unsigned char samples[16];// = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

void add_sample(unsigned char data)
{
    if (samples[sample_idx] == data) return;
    sample_idx++;
    if (sample_idx >= 16) sample_idx = 0;
    samples[sample_idx] = data;
}

unsigned char get_average()
{
    int res = 0;
    int i;
    for (i = 0; i < 16; i++)
    {
        res += samples[i];
    }
    return (res / 16) & 0xFF;
}

void pwm_init()
{
       // set up 2 PWM channels on PB1 and PB2 using Timer1

    //TCCR1A = 0;     // disable all PWM on Timer1 whilst we set it up
    ICR1 = 4999;   // frequency is every 20ms

    // Set PB1 and PB2 as outputs
    DDRB |= _BV(1) |  _BV(2);

    // Configure timer 1 for Fast PWM mode via ICR1, with prescaler 64 
    TCCR1A = (1 << WGM11) | (2<<6) | (2<<4);
    TCCR1B = (1 << WGM13) | (1<<WGM12) | (1 << CS11) | (1 << CS10);

    //TCCR1A |= 2 <<  6;  // enable PWM on port B1 in non-inverted compare mode 2
    //TCCR1A |= 2 <<  4;  // enable PWM on port B2 in non-inverted compare mode 2

    OCR1A = 325;//ICR1 * 1.5 /20; // 2ms pulse to left motor on PB1
    OCR1B = 325;//ICR1 * 1.5 /20; // 2ms pulse to right motor on PB2
}

int main(){
    pwm_init();
    adc_enable();

    while (1)
    {
        add_sample(adc_read(0));
        OCR1A = 0x100 | get_average();
    }

    //blink();
    return 0;
}

